/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorProgressDisplayLocation;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.file.fullDatafile.GeneratedFullDataSourceProvider;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.util.FormatUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.RollingAverage;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;

public class WorldGenModule
implements Closeable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final GeneratedFullDataSourceProvider.IOnWorldGenCompleteListener onWorldGenCompleteListener;
    private final GeneratedFullDataSourceProvider dataSourceProvider;
    private final Supplier<? extends AbstractWorldGenState> worldGenStateSupplier;
    private final AtomicReference<AbstractWorldGenState> worldGenStateRef = new AtomicReference();

    public WorldGenModule(GeneratedFullDataSourceProvider.IOnWorldGenCompleteListener onWorldGenCompleteListener, GeneratedFullDataSourceProvider dataSourceProvider, Supplier<? extends AbstractWorldGenState> worldGenStateSupplier) {
        this.onWorldGenCompleteListener = onWorldGenCompleteListener;
        this.dataSourceProvider = dataSourceProvider;
        this.worldGenStateSupplier = worldGenStateSupplier;
    }

    public void startWorldGen(GeneratedFullDataSourceProvider dataFileHandler, AbstractWorldGenState newWgs) {
        if (!this.worldGenStateRef.compareAndSet(null, newWgs)) {
            LOGGER.warn("Failed to start world gen due to concurrency");
            newWgs.closeAsync(false);
        }
        dataFileHandler.addWorldGenCompleteListener(this.onWorldGenCompleteListener);
        dataFileHandler.setWorldGenerationQueue(newWgs.worldGenerationQueue);
    }

    public void stopWorldGen(GeneratedFullDataSourceProvider dataFileHandler) {
        AbstractWorldGenState worldGenState = this.worldGenStateRef.get();
        if (worldGenState == null) {
            LOGGER.warn("Attempted to stop world gen when it was not running");
            return;
        }
        while (!this.worldGenStateRef.compareAndSet(worldGenState, null)) {
            worldGenState = this.worldGenStateRef.get();
            if (worldGenState != null) continue;
            return;
        }
        dataFileHandler.clearRetrievalQueue();
        worldGenState.closeAsync(true).join();
        dataFileHandler.removeWorldGenCompleteListener(this.onWorldGenCompleteListener);
    }

    public void worldGenTick() {
        DhBlockPos2D targetPosForGeneration;
        AbstractWorldGenState worldGenState;
        boolean shouldDoWorldGen = this.onWorldGenCompleteListener.shouldDoWorldGen();
        boolean bl = !DhApiWorldProxy.INSTANCE.getReadOnly();
        boolean isWorldGenRunning = this.isWorldGenRunning();
        if ((shouldDoWorldGen &= bl) && !isWorldGenRunning) {
            this.startWorldGen(this.dataSourceProvider, this.worldGenStateSupplier.get());
        } else if (!shouldDoWorldGen && isWorldGenRunning) {
            this.stopWorldGen(this.dataSourceProvider);
        }
        if (this.isWorldGenRunning() && (worldGenState = this.worldGenStateRef.get()) != null && (targetPosForGeneration = this.onWorldGenCompleteListener.getTargetPosForGeneration()) != null) {
            worldGenState.startGenerationQueueAndSetTargetPos(targetPosForGeneration);
        }
    }

    @Override
    public void close() {
        AbstractWorldGenState worldGenState = this.worldGenStateRef.get();
        if (worldGenState != null) {
            while (!this.worldGenStateRef.compareAndSet(worldGenState, null) && (worldGenState = this.worldGenStateRef.get()) != null) {
            }
            if (worldGenState != null) {
                worldGenState.closeAsync(true).join();
            }
        }
    }

    public boolean isWorldGenRunning() {
        return this.worldGenStateRef.get() != null;
    }

    public void addDebugMenuStringsToList(List<String> messageList) {
        AbstractWorldGenState worldGenState = this.worldGenStateRef.get();
        if (worldGenState == null) {
            return;
        }
        String waitingCountStr = F3Screen.NUMBER_FORMAT.format(worldGenState.worldGenerationQueue.getWaitingTaskCount());
        String inProgressCountStr = F3Screen.NUMBER_FORMAT.format(worldGenState.worldGenerationQueue.getInProgressTaskCount());
        String totalCountEstimateStr = F3Screen.NUMBER_FORMAT.format(worldGenState.worldGenerationQueue.getRetrievalEstimatedRemainingChunkCount());
        String message = "World Gen/Import Tasks: " + waitingCountStr + "/" + totalCountEstimateStr + " (in progress " + inProgressCountStr + ")";
        double chunksPerSec = worldGenState.getEstimatedChunksPerSecond();
        if (chunksPerSec > -1.0) {
            message = message + ", " + F3Screen.NUMBER_FORMAT.format(chunksPerSec) + " chunks/sec";
        }
        messageList.add(message);
        worldGenState.worldGenerationQueue.addDebugMenuStringsToList(messageList);
    }

    public static abstract class AbstractWorldGenState {
        private static long firstProgressMessageSentMs = 0L;
        public IFullDataSourceRetrievalQueue worldGenerationQueue;
        private static final ThreadPoolExecutor PROGRESS_UPDATER_THREAD = ThreadUtil.makeSingleDaemonThreadPool("World Gen Progress Updater");
        private boolean progressUpdateThreadRunning = false;

        CompletableFuture<Void> closeAsync(boolean doInterrupt) {
            this.progressUpdateThreadRunning = false;
            return ((CompletableFuture)((CompletableFuture)this.worldGenerationQueue.startClosingAsync(true, doInterrupt).exceptionally(e -> {
                LOGGER.error("Error during first stage of generation queue shutdown, Error: [" + e.getMessage() + "].", e);
                return null;
            })).thenRun(this.worldGenerationQueue::close)).exceptionally(e -> {
                LOGGER.error("Error during second stage of generation queue shutdown, Error: [" + e.getMessage() + "].", e);
                return null;
            });
        }

        public void startGenerationQueueAndSetTargetPos(DhBlockPos2D targetPosForGeneration) {
            this.worldGenerationQueue.startAndSetTargetPos(targetPosForGeneration);
            this.startProgressUpdateThread();
        }

        private void startProgressUpdateThread() {
            if (!this.progressUpdateThreadRunning) {
                this.progressUpdateThreadRunning = true;
                PROGRESS_UPDATER_THREAD.execute(() -> {
                    while (this.progressUpdateThreadRunning) {
                        try {
                            this.sendRetrievalProgress();
                            int sleepTimeInSec = Config.Common.WorldGenerator.generationProgressDisplayIntervalInSeconds.get();
                            Thread.sleep((long)sleepTimeInSec * 1000L);
                        }
                        catch (Exception e) {
                            LOGGER.error("Unexpected issue displaying chunk retrieval progress [" + e.getMessage() + "].", (Throwable)e);
                        }
                    }
                });
            }
        }

        private void sendRetrievalProgress() {
            double chunksPerSec;
            int remainingChunkCount = this.worldGenerationQueue.getRetrievalEstimatedRemainingChunkCount();
            String remainingChunkCountStr = F3Screen.NUMBER_FORMAT.format(remainingChunkCount += this.worldGenerationQueue.getQueuedChunkCount());
            String message = "DH Gen/Import: " + remainingChunkCountStr + " chunks left.";
            int msToShowDisableInstructions = Config.Common.WorldGenerator.generationProgressDisableMessageDisplayTimeInSeconds.get() * 1000;
            if (msToShowDisableInstructions > 0) {
                long timeSinceFirstMessageInMs = System.currentTimeMillis() - firstProgressMessageSentMs;
                if (firstProgressMessageSentMs == 0L || timeSinceFirstMessageInMs < (long)msToShowDisableInstructions) {
                    message = message + " This message can be hidden in the DH config.";
                }
            }
            if ((chunksPerSec = this.getEstimatedChunksPerSecond()) > 0.0) {
                long estimatedRemainingTime = (long)((double)remainingChunkCount / chunksPerSec);
                message = message + " ETA: " + FormatUtil.formatEta(Duration.ofSeconds(estimatedRemainingTime));
            }
            if (remainingChunkCount != 0) {
                EDhApiDistantGeneratorProgressDisplayLocation displayLocation = Config.Common.WorldGenerator.showGenerationProgress.get();
                if (displayLocation == EDhApiDistantGeneratorProgressDisplayLocation.OVERLAY) {
                    ClientApi.INSTANCE.showOverlayMessageNextFrame(message);
                } else if (displayLocation == EDhApiDistantGeneratorProgressDisplayLocation.CHAT) {
                    ClientApi.INSTANCE.showChatMessageNextFrame(message);
                } else if (displayLocation == EDhApiDistantGeneratorProgressDisplayLocation.LOG) {
                    LOGGER.info(message);
                }
                if (firstProgressMessageSentMs == 0L) {
                    firstProgressMessageSentMs = System.currentTimeMillis();
                }
            }
        }

        public double getEstimatedChunksPerSecond() {
            RollingAverage avg = this.worldGenerationQueue.getRollingAverageChunkGenTimeInMs();
            if (avg == null) {
                return -1.0;
            }
            PriorityTaskPicker.Executor executor = ThreadPoolUtil.getWorldGenExecutor();
            int threadCount = 1;
            if (executor != null) {
                threadCount = executor.getPoolSize();
            }
            double chunksPerSecond = 1.0 / avg.getAverage() * 1000.0;
            chunksPerSecond = (double)threadCount * chunksPerSecond;
            return chunksPerSecond;
        }
    }
}

