/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.multiplayer.fullData;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.multiplayer.fullData.FullDataPayload;
import com.seibel.distanthorizons.core.network.INetworkObject;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataSplitMessage;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.util.LodUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;

public class FullDataPayloadReceiver
implements AutoCloseable {
    private static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Common.Logging.logNetworkEvent.get());
    private final ConcurrentMap<Integer, CompositeByteBuf> buffersById = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).removalListener(notification -> {
        if (notification.getCause() != RemovalCause.REPLACED) {
            Objects.requireNonNull((CompositeByteBuf)notification.getValue()).release();
        }
    }).build().asMap();

    @Override
    public void close() {
        this.buffersById.clear();
    }

    public void receiveChunk(FullDataSplitMessage message) {
        this.buffersById.compute(message.bufferId, (bufferId, composite) -> {
            if (message.isFirst) {
                if (composite != null) {
                    composite.release();
                    LOGGER.debug("Released existing full data buffer [" + message.bufferId + "]", new Object[0]);
                }
                composite = ByteBufAllocator.DEFAULT.compositeBuffer();
                LOGGER.debug("Created new full data buffer [" + message.bufferId + "]: [" + composite + "]", new Object[0]);
            } else if (composite == null) {
                LOGGER.debug("Received non-first full data chunk for empty buffer [" + message.bufferId + "]: [" + message.buffer + "].", new Object[0]);
                return null;
            }
            composite.addComponent(true, message.buffer);
            LOGGER.debug("Updated full data buffer [" + message.bufferId + "]: [" + composite + "].", new Object[0]);
            return composite;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullDataSourceV2DTO decodeDataSourceAndReleaseBuffer(FullDataPayload msg) {
        CompositeByteBuf compositeByteBuffer = (CompositeByteBuf)this.buffersById.get(msg.dtoBufferId);
        LodUtil.assertTrue(compositeByteBuffer != null);
        try {
            FullDataSourceV2DTO fullDataSourceV2DTO = INetworkObject.decodeToInstance(FullDataSourceV2DTO.CreateEmptyDataSourceForDecoding(), (ByteBuf)compositeByteBuffer);
            return fullDataSourceV2DTO;
        }
        finally {
            this.buffersById.remove(msg.dtoBufferId);
        }
    }
}

