/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.dto;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.network.INetworkObject;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListParent;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.IBaseDTO;
import com.seibel.distanthorizons.core.util.BoolUtil;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.ListUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullDataSourceV2DTO
extends PhantomArrayListParent
implements IBaseDTO<Long>,
INetworkObject,
AutoCloseable {
    public static final boolean VALIDATE_INPUT_DATAPOINTS = true;
    public long pos;
    public int levelMinY;
    public int dataChecksum;
    public ByteArrayList compressedDataByteArray;
    public ByteArrayList compressedColumnGenStepByteArray;
    public ByteArrayList compressedWorldCompressionModeByteArray;
    public ByteArrayList compressedMappingByteArray;
    public byte dataFormatVersion;
    public byte compressionModeValue;
    @Nullable
    public Boolean applyToParent;
    @Nullable
    public Boolean applyToChildren;
    public long lastModifiedUnixDateTime;
    public long createdUnixDateTime;
    public static final PhantomArrayListPool ARRAY_LIST_POOL = new PhantomArrayListPool("V2DTO");

    public static FullDataSourceV2DTO CreateFromDataSource(FullDataSourceV2 dataSource, EDhApiDataCompressionMode compressionModeEnum) throws IOException {
        FullDataSourceV2DTO dto = FullDataSourceV2DTO.CreateEmptyDataSourceForDecoding();
        FullDataSourceV2DTO.writeDataSourceDataArrayToBlob(dataSource.dataPoints, dto.compressedDataByteArray, compressionModeEnum);
        FullDataSourceV2DTO.writeGenerationStepsToBlob(dataSource.columnGenerationSteps, dto.compressedColumnGenStepByteArray, compressionModeEnum);
        FullDataSourceV2DTO.writeWorldCompressionModeToBlob(dataSource.columnWorldCompressionMode, dto.compressedWorldCompressionModeByteArray, compressionModeEnum);
        FullDataSourceV2DTO.writeDataMappingToBlob(dataSource.mapping, dto.compressedMappingByteArray, compressionModeEnum);
        dto.pos = dataSource.getPos();
        dto.dataChecksum = dataSource.hashCode();
        dto.dataFormatVersion = 1;
        dto.compressionModeValue = compressionModeEnum.value;
        dto.lastModifiedUnixDateTime = dataSource.lastModifiedUnixDateTime;
        dto.createdUnixDateTime = dataSource.createdUnixDateTime;
        dto.applyToParent = dataSource.applyToParent;
        dto.applyToChildren = dataSource.applyToChildren;
        dto.levelMinY = dataSource.levelMinY;
        return dto;
    }

    public static FullDataSourceV2DTO CreateEmptyDataSourceForDecoding() {
        return new FullDataSourceV2DTO();
    }

    private FullDataSourceV2DTO() {
        super(ARRAY_LIST_POOL, 4, 0, 0);
        this.compressedDataByteArray = this.pooledArraysCheckout.getByteArray(0, 0);
        this.compressedColumnGenStepByteArray = this.pooledArraysCheckout.getByteArray(1, 0);
        this.compressedWorldCompressionModeByteArray = this.pooledArraysCheckout.getByteArray(2, 0);
        this.compressedMappingByteArray = this.pooledArraysCheckout.getByteArray(3, 0);
    }

    public FullDataSourceV2 createDataSource(@NotNull ILevelWrapper levelWrapper) throws IOException, InterruptedException, DataCorruptedException {
        FullDataSourceV2 dataSource = FullDataSourceV2.createEmpty(this.pos);
        this.internalPopulateDataSource(dataSource, levelWrapper, false);
        return dataSource;
    }

    public FullDataSourceV2 createUnitTestDataSource() throws IOException, InterruptedException, DataCorruptedException {
        return this.internalPopulateDataSource(FullDataSourceV2.createEmpty(this.pos), null, true);
    }

    private FullDataSourceV2 internalPopulateDataSource(FullDataSourceV2 dataSource, ILevelWrapper levelWrapper, boolean unitTest) throws IOException, InterruptedException, DataCorruptedException {
        EDhApiDataCompressionMode compressionModeEnum;
        if (1 != this.dataFormatVersion) {
            throw new IllegalStateException("There should only be one data format [1].");
        }
        try {
            compressionModeEnum = this.getCompressionMode();
        }
        catch (IllegalArgumentException e) {
            throw new DataCorruptedException(e);
        }
        FullDataSourceV2DTO.readBlobToGenerationSteps(this.compressedColumnGenStepByteArray, dataSource.columnGenerationSteps, compressionModeEnum);
        FullDataSourceV2DTO.readBlobToWorldCompressionMode(this.compressedWorldCompressionModeByteArray, dataSource.columnWorldCompressionMode, compressionModeEnum);
        FullDataSourceV2DTO.readBlobToDataSourceDataArray(this.compressedDataByteArray, dataSource.dataPoints, compressionModeEnum);
        dataSource.mapping.clear(dataSource.getPos());
        if (!unitTest) {
            if (levelWrapper == null) {
                throw new NullPointerException("No level wrapper present, unable to deserialize data map. This should only be used for unit tests.");
            }
            FullDataPointIdMap newMap = FullDataSourceV2DTO.readBlobToDataMapping(this.compressedMappingByteArray, dataSource.getPos(), levelWrapper, compressionModeEnum);
            dataSource.mapping.addAll(newMap);
            if (dataSource.mapping.size() != newMap.size()) {
                LodUtil.assertNotReach("ID maps out of sync for pos: " + this.pos);
            }
        }
        dataSource.lastModifiedUnixDateTime = this.lastModifiedUnixDateTime;
        dataSource.createdUnixDateTime = this.createdUnixDateTime;
        dataSource.levelMinY = this.levelMinY;
        dataSource.isEmpty = false;
        if (this.applyToParent != null) {
            dataSource.applyToParent = this.applyToParent;
        }
        if (this.applyToChildren != null) {
            dataSource.applyToChildren = this.applyToChildren;
        }
        return dataSource;
    }

    private static void writeDataSourceDataArrayToBlob(LongArrayList[] inputDataArray, ByteArrayList outputByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DhDataOutputStream compressedOut = new DhDataOutputStream(byteArrayOutputStream, compressionModeEnum);
        int dataArrayLength = 4096;
        for (int xz = 0; xz < dataArrayLength; ++xz) {
            LongArrayList dataColumn = inputDataArray[xz];
            int columnLength = dataColumn != null ? (int)dataColumn.size() : 0;
            compressedOut.writeShort(columnLength);
            for (int y = 0; y < columnLength; ++y) {
                compressedOut.writeLong(dataColumn.getLong(y));
            }
        }
        compressedOut.flush();
        byteArrayOutputStream.close();
        outputByteArray.addElements(0, byteArrayOutputStream.toByteArray());
    }

    private static void readBlobToDataSourceDataArray(ByteArrayList inputCompressedDataByteArray, LongArrayList[] outputDataLongArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException, DataCorruptedException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inputCompressedDataByteArray.elements());
        DhDataInputStream compressedIn = new DhDataInputStream(byteArrayInputStream, compressionModeEnum);
        int dataArrayLength = 4096;
        for (int xz = 0; xz < dataArrayLength; ++xz) {
            int dataColumnLength = compressedIn.readShort();
            if (dataColumnLength < 0) {
                throw new DataCorruptedException("Read DataSource Blob data at index [" + xz + "], column length [" + dataColumnLength + "] should be greater than zero.");
            }
            LongArrayList dataColumn = outputDataLongArray[xz];
            ListUtil.clearAndSetSize(dataColumn, dataColumnLength);
            for (int y = 0; y < dataColumnLength; ++y) {
                long dataPoint = compressedIn.readLong();
                FullDataPointUtil.validateDatapoint(dataPoint);
                dataColumn.set(y, dataPoint);
            }
        }
    }

    private static void writeGenerationStepsToBlob(ByteArrayList inputColumnGenStepByteArray, ByteArrayList outputByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DhDataOutputStream compressedOut = new DhDataOutputStream(byteArrayOutputStream, compressionModeEnum);
        for (int i = 0; i < inputColumnGenStepByteArray.size(); ++i) {
            compressedOut.writeByte(inputColumnGenStepByteArray.getByte(i));
        }
        compressedOut.flush();
        byteArrayOutputStream.close();
        outputByteArray.addElements(0, byteArrayOutputStream.toByteArray());
    }

    private static void readBlobToGenerationSteps(ByteArrayList inputCompressedDataByteArray, ByteArrayList outputByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException, DataCorruptedException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inputCompressedDataByteArray.elements());
        DhDataInputStream compressedIn = new DhDataInputStream(byteArrayInputStream, compressionModeEnum);
        try {
            compressedIn.readFully(outputByteArray.elements(), 0, 4096);
        }
        catch (EOFException e) {
            throw new DataCorruptedException(e);
        }
    }

    private static void writeWorldCompressionModeToBlob(ByteArrayList inputWorldCompressionModeByteArray, ByteArrayList outputByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DhDataOutputStream compressedOut = new DhDataOutputStream(byteArrayOutputStream, compressionModeEnum);
        for (int i = 0; i < inputWorldCompressionModeByteArray.size(); ++i) {
            compressedOut.write(inputWorldCompressionModeByteArray.getByte(i));
        }
        compressedOut.flush();
        byteArrayOutputStream.close();
        outputByteArray.addElements(0, byteArrayOutputStream.toByteArray());
    }

    private static void readBlobToWorldCompressionMode(ByteArrayList inputCompressedDataByteArray, ByteArrayList outputByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException, DataCorruptedException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inputCompressedDataByteArray.elements());
        DhDataInputStream compressedIn = new DhDataInputStream(byteArrayInputStream, compressionModeEnum);
        try {
            compressedIn.readFully(outputByteArray.elements(), 0, 4096);
        }
        catch (EOFException e) {
            throw new DataCorruptedException(e);
        }
    }

    private static void writeDataMappingToBlob(FullDataPointIdMap mapping, ByteArrayList outputByteArray, EDhApiDataCompressionMode compressionModeEnum) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DhDataOutputStream compressedOut = new DhDataOutputStream(byteArrayOutputStream, compressionModeEnum);
        mapping.serialize(compressedOut);
        compressedOut.flush();
        byteArrayOutputStream.close();
        outputByteArray.addElements(0, byteArrayOutputStream.toByteArray());
    }

    private static FullDataPointIdMap readBlobToDataMapping(ByteArrayList compressedMappingByteArray, long pos, @NotNull ILevelWrapper levelWrapper, EDhApiDataCompressionMode compressionModeEnum) throws IOException, InterruptedException, DataCorruptedException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedMappingByteArray.elements());
        DhDataInputStream compressedIn = new DhDataInputStream(byteArrayInputStream, compressionModeEnum);
        FullDataPointIdMap mapping = FullDataPointIdMap.deserialize(compressedIn, pos, levelWrapper);
        return mapping;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.pos);
        out.writeInt(this.dataChecksum);
        out.writeInt(this.compressedDataByteArray.size());
        out.writeBytes(this.compressedDataByteArray.elements(), 0, this.compressedDataByteArray.size());
        out.writeInt(this.compressedColumnGenStepByteArray.size());
        out.writeBytes(this.compressedColumnGenStepByteArray.elements(), 0, this.compressedColumnGenStepByteArray.size());
        out.writeInt(this.compressedWorldCompressionModeByteArray.size());
        out.writeBytes(this.compressedWorldCompressionModeByteArray.elements(), 0, this.compressedWorldCompressionModeByteArray.size());
        out.writeInt(this.compressedMappingByteArray.size());
        out.writeBytes(this.compressedMappingByteArray.elements(), 0, this.compressedMappingByteArray.size());
        out.writeByte((int)this.dataFormatVersion);
        out.writeByte((int)this.compressionModeValue);
        out.writeBoolean(BoolUtil.falseIfNull(this.applyToParent));
        out.writeBoolean(BoolUtil.falseIfNull(this.applyToChildren));
        out.writeLong(this.lastModifiedUnixDateTime);
        out.writeLong(this.createdUnixDateTime);
    }

    @Override
    public void decode(ByteBuf in) {
        this.pos = in.readLong();
        this.dataChecksum = in.readInt();
        this.compressedDataByteArray.size(in.readInt());
        in.readBytes(this.compressedDataByteArray.elements(), 0, this.compressedDataByteArray.size());
        this.compressedColumnGenStepByteArray.size(in.readInt());
        in.readBytes(this.compressedColumnGenStepByteArray.elements(), 0, this.compressedColumnGenStepByteArray.size());
        this.compressedWorldCompressionModeByteArray.size(in.readInt());
        in.readBytes(this.compressedWorldCompressionModeByteArray.elements(), 0, this.compressedWorldCompressionModeByteArray.size());
        this.compressedMappingByteArray.size(in.readInt());
        in.readBytes(this.compressedMappingByteArray.elements(), 0, this.compressedMappingByteArray.size());
        this.dataFormatVersion = in.readByte();
        this.compressionModeValue = in.readByte();
        this.applyToParent = in.readBoolean();
        this.applyToChildren = in.readBoolean();
        this.lastModifiedUnixDateTime = in.readLong();
        this.createdUnixDateTime = in.readLong();
    }

    public EDhApiDataCompressionMode getCompressionMode() throws IllegalArgumentException {
        return EDhApiDataCompressionMode.getFromValue(this.compressionModeValue);
    }

    @Override
    public Long getKey() {
        return this.pos;
    }

    @Override
    public String getKeyDisplayString() {
        return DhSectionPos.toString(this.pos);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("levelMinY", this.levelMinY).add("pos", this.pos).add("dataChecksum", this.dataChecksum).add("compressedDataByteArray length", this.compressedDataByteArray.size()).add("compressedColumnGenStepByteArray length", this.compressedColumnGenStepByteArray.size()).add("compressedWorldCompressionModeByteArray length", this.compressedWorldCompressionModeByteArray.size()).add("compressedMappingByteArray length", this.compressedMappingByteArray.size()).add("dataFormatVersion", (int)this.dataFormatVersion).add("compressionModeValue", (int)this.compressionModeValue).add("applyToParent", (Object)this.applyToParent).add("applyToChildren", (Object)this.applyToChildren).add("lastModifiedUnixDateTime", this.lastModifiedUnixDateTime).add("createdUnixDateTime", this.createdUnixDateTime).toString();
    }
}

