/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.threading;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.objects.RollingAverage;
import com.seibel.distanthorizons.core.util.threading.DhThreadFactory;
import com.seibel.distanthorizons.core.util.threading.RateLimitedThreadPoolExecutor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PriorityTaskPicker {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final ConfigEntry<Integer> threadCountConfig = Config.Common.MultiThreading.numberOfThreads;
    private final RateLimitedThreadPoolExecutor threadPoolExecutor = new RateLimitedThreadPoolExecutor(this.threadCountConfig.getMax(), new DhThreadFactory("PriorityTaskPicker", 1, false), new ArrayBlockingQueue<Runnable>(this.threadCountConfig.getMax()));
    private final ArrayList<Executor> executors = new ArrayList();
    private final ReentrantLock taskPickerLock = new ReentrantLock();
    private final AtomicInteger occupiedThreads = new AtomicInteger(0);
    private final AtomicBoolean isShutDownRef = new AtomicBoolean(false);

    public Executor createExecutor() {
        Executor executor = new Executor();
        this.executors.add(executor);
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryStartNextTask() {
        if (!this.taskPickerLock.tryLock()) return;
        try {
            for (Executor executor2 : this.executors.stream().sorted(Comparator.comparingLong(executor -> ((Executor)executor).totalRuntimeNanos.get()))::iterator) {
                TrackedRunnable task;
                while (this.occupiedThreads.get() < this.threadCountConfig.get() && (task = (TrackedRunnable)executor2.tasks.poll()) != null) {
                    try {
                        this.threadPoolExecutor.execute(task);
                        this.occupiedThreads.getAndIncrement();
                        executor2.runningTasks.getAndIncrement();
                    }
                    catch (RejectedExecutionException e) {
                        if (!this.isShutDownRef.get()) throw e;
                        executor2.tasks.clear();
                    }
                }
                continue;
                return;
            }
        }
        finally {
            this.taskPickerLock.unlock();
        }
    }

    public void shutdown() {
        LOGGER.info("Shutting down PriorityTaskPicker thread pool...");
        this.isShutDownRef.set(true);
        try {
            this.threadPoolExecutor.shutdown();
            if (!this.threadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.threadPoolExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public class Executor
    extends AbstractExecutorService {
        private final Queue<TrackedRunnable> tasks = new ConcurrentLinkedQueue<TrackedRunnable>();
        private final AtomicInteger runningTasks = new AtomicInteger(0);
        private final AtomicInteger completedTasks = new AtomicInteger(0);
        private final RollingAverage runTimeInMsRollingAverage = new RollingAverage(200);
        private final AtomicLong totalRuntimeNanos = new AtomicLong(0L);

        @Override
        public void execute(@NotNull Runnable command) {
            this.tasks.add(new TrackedRunnable(this, command));
            PriorityTaskPicker.this.tryStartNextTask();
        }

        public int getQueueSize() {
            return this.tasks.size();
        }

        public int getPoolSize() {
            return (Integer)PriorityTaskPicker.this.threadCountConfig.get();
        }

        public int getRunningTaskCount() {
            return this.runningTasks.get();
        }

        public int getCompletedTaskCount() {
            return this.completedTasks.get();
        }

        public double getAverageRunTimeInMs() {
            return this.runTimeInMsRollingAverage.getAverage();
        }

        public void remove(@NotNull Runnable command) {
            this.tasks.removeIf(trackedRunnable -> trackedRunnable.command == command);
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
            return false;
        }
    }

    private class TrackedRunnable
    implements Runnable {
        private final Executor executor;
        public final Runnable command;

        public TrackedRunnable(Executor executor, Runnable command) {
            this.executor = executor;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.nanoTime();
            try {
                this.command.run();
            }
            finally {
                long timeElapsed = System.nanoTime() - startTime;
                this.executor.runTimeInMsRollingAverage.addValue(TimeUnit.NANOSECONDS.toMillis(timeElapsed));
                PriorityTaskPicker.this.occupiedThreads.getAndDecrement();
                this.executor.runningTasks.getAndDecrement();
                this.executor.completedTasks.getAndIncrement();
                this.executor.totalRuntimeNanos.addAndGet(timeElapsed);
                PriorityTaskPicker.this.tryStartNextTask();
            }
        }
    }
}

