/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui;

import com.seibel.distanthorizons.api.enums.config.DisallowSelectingViaConfigGui;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigBase;
import com.seibel.distanthorizons.core.config.types.AbstractConfigType;
import com.seibel.distanthorizons.core.config.types.ConfigCategory;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.config.types.ConfigUIButton;
import com.seibel.distanthorizons.core.config.types.ConfigUIComment;
import com.seibel.distanthorizons.core.config.types.ConfigUiLinkedEntry;
import com.seibel.distanthorizons.core.jar.updater.SelfUpdater;
import com.seibel.distanthorizons.core.util.AnnotationUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.IConfigGui;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.DhScreen;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.GuiHelper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.TexturedButtonWidget;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.updater.ChangelogScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassicConfigGUI {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ConfigCoreInterface CONFIG_CORE_INTERFACE = new ConfigCoreInterface();
    private static final Pattern INTEGER_ONLY_REGEX = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY_REGEX = Pattern.compile("-?([\\d]+\\.?[\\d]*|[\\d]*\\.?[\\d]+|\\.)");

    private static void textField(AbstractConfigType info, Function<String, Number> func, Pattern pattern, boolean cast) {
        ((EntryInfo)info.guiValue).widget = (editBox, button) -> stringValue -> {
            boolean isNumber = pattern != null;
            if (!(stringValue = stringValue.trim()).isEmpty() && isNumber && !pattern.matcher((CharSequence)stringValue).matches()) {
                return false;
            }
            Number value = info.typeIsFloatingPointNumber() ? 0.0 : 0.0;
            ((EntryInfo)info.guiValue).error = null;
            if (isNumber && !stringValue.isEmpty() && !stringValue.equals("-") && !stringValue.equals(".")) {
                try {
                    value = (Number)func.apply((String)stringValue);
                }
                catch (Exception e) {
                    value = null;
                }
                byte isValid = ((ConfigEntry)info).isValid(value);
                switch (isValid) {
                    case 0: {
                        ((EntryInfo)info.guiValue).error = null;
                        break;
                    }
                    case -1: {
                        ((EntryInfo)info.guiValue).error = new AbstractMap.SimpleEntry<EditBox, MutableComponent>((EditBox)editBox, GuiHelper.TextOrTranslatable("\u00a7cMinimum length is " + String.valueOf(((ConfigEntry)info).getMin())));
                        break;
                    }
                    case 1: {
                        ((EntryInfo)info.guiValue).error = new AbstractMap.SimpleEntry<EditBox, MutableComponent>((EditBox)editBox, GuiHelper.TextOrTranslatable("\u00a7cMaximum length is " + String.valueOf(((ConfigEntry)info).getMax())));
                        break;
                    }
                    case 2: {
                        ((EntryInfo)info.guiValue).error = new AbstractMap.SimpleEntry<EditBox, MutableComponent>((EditBox)editBox, GuiHelper.TextOrTranslatable("\u00a7cValue is invalid"));
                    }
                }
            }
            ((EntryInfo)info.guiValue).tempValue = stringValue;
            editBox.setTextColor(((ConfigEntry)info).isValid(value) == 0 ? -1 : -34953);
            if (info.getType() == String.class || info.getType() == List.class) {
                ((ConfigEntry)info).uiSetWithoutSaving(stringValue);
            } else if (((ConfigEntry)info).isValid(value) == 0) {
                if (!cast) {
                    ((ConfigEntry)info).uiSetWithoutSaving(value);
                } else {
                    ((ConfigEntry)info).uiSetWithoutSaving(value.intValue());
                }
            }
            return true;
        };
    }

    public static Screen getScreen(ConfigBase configBase, Screen parent, String category) {
        return new ConfigScreen(configBase, parent, category);
    }

    private static void initEntry(AbstractConfigType configType, String translationPrefix) {
        configType.guiValue = new EntryInfo();
        Class<?> fieldClass = configType.getType();
        if (ConfigEntry.class.isAssignableFrom(configType.getClass())) {
            if (fieldClass == Integer.class) {
                ClassicConfigGUI.textField(configType, Integer::parseInt, INTEGER_ONLY_REGEX, true);
            } else if (fieldClass == Double.class) {
                ClassicConfigGUI.textField(configType, Double::parseDouble, DECIMAL_ONLY_REGEX, false);
            } else if (fieldClass == String.class || fieldClass == List.class) {
                ClassicConfigGUI.textField(configType, String::length, null, true);
            } else if (fieldClass == Boolean.class) {
                Function<Object, Component> func = value -> GuiHelper.Translatable("distanthorizons.general." + ((Boolean)value != false ? "true" : "false"), new Object[0]).withStyle((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                ((EntryInfo)configType.guiValue).widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    ((ConfigEntry)configType).uiSetWithoutSaving((Boolean)configType.get() == false);
                    button.setMessage((Component)func.apply(configType.get()));
                }, func);
            } else if (fieldClass.isEnum()) {
                List<?> values = Arrays.asList(configType.getType().getEnumConstants());
                Function<Object, Component> func = value -> GuiHelper.Translatable(translationPrefix + "enum." + fieldClass.getSimpleName() + "." + configType.get().toString(), new Object[0]);
                ((EntryInfo)configType.guiValue).widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int startingIndex = values.indexOf(configType.get());
                    Enum enumValue = (Enum)values.get(startingIndex);
                    int index = startingIndex + 1;
                    int n = index = index >= values.size() ? 0 : index;
                    while (index != startingIndex && AnnotationUtil.doesEnumHaveAnnotation(enumValue = (Enum)values.get(index), DisallowSelectingViaConfigGui.class)) {
                        index = ++index >= values.size() ? 0 : index;
                    }
                    if (index == startingIndex) {
                        enumValue = (Enum)values.get(startingIndex);
                        LOGGER.warn("Enum [" + String.valueOf(enumValue.getClass()) + "] doesn't contain any values that should be selectable via the UI, sticking to the currently selected value [" + String.valueOf(enumValue) + "].");
                    }
                    ((ConfigEntry)configType).uiSetWithoutSaving(enumValue);
                    button.setMessage((Component)func.apply(configType.get()));
                }, func);
            }
        } else if (ConfigCategory.class.isAssignableFrom(configType.getClass())) {
            // empty if block
        }
    }

    public static class EntryInfo {
        Object widget;
        Map.Entry<EditBox, Component> error;
        String tempValue;
        int index;
    }

    private static class ConfigScreen
    extends DhScreen {
        private final ConfigBase configBase;
        private final String translationPrefix;
        private final Screen parent;
        private final String category;
        private ConfigListWidget list;
        private boolean reload = false;
        private Button doneButton;

        protected ConfigScreen(ConfigBase configBase, Screen parent, String category) {
            super((Component)GuiHelper.Translatable(I18n.exists((String)(configBase.modID + ".config" + (String)(category.isEmpty() ? "." + category : "") + ".title")) ? configBase.modID + ".config.title" : configBase.modID + ".config" + (String)(category.isEmpty() ? "" : "." + category) + ".title", new Object[0]));
            this.configBase = configBase;
            this.parent = parent;
            this.category = category;
            this.translationPrefix = configBase.modID + ".config.";
        }

        public void tick() {
            super.tick();
        }

        public void onClose() {
            ConfigBase.INSTANCE.configFileINSTANCE.saveToFile();
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
            ClassicConfigGUI.CONFIG_CORE_INTERFACE.onScreenChangeListenerList.forEach(listener -> listener.run());
        }

        protected void init() {
            super.init();
            if (!this.reload) {
                ConfigBase.INSTANCE.configFileINSTANCE.loadFromFile();
            }
            if (Config.Client.Advanced.AutoUpdater.enableAutoUpdater.get().booleanValue() && !ModInfo.IS_DEV_BUILD) {
                this.addBtn(new TexturedButtonWidget(this.width - 28, this.height - 28, 20, 20, 0, 0, 0, ResourceLocation.fromNamespaceAndPath((String)"distanthorizons", (String)"textures/gui/changelog.png"), 20, 20, buttonWidget -> {
                    ChangelogScreen changelogScreen = new ChangelogScreen(this);
                    if (changelogScreen.usable) {
                        Objects.requireNonNull(this.minecraft).setScreen((Screen)changelogScreen);
                    } else {
                        LOGGER.warn("Changelog was not able to open");
                    }
                }, (Component)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0])));
            }
            this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.general.cancel", new Object[0]), this.width / 2 - 154, this.height - 28, 150, 20, button -> {
                ConfigBase.INSTANCE.configFileINSTANCE.loadFromFile();
                Objects.requireNonNull(this.minecraft).setScreen(this.parent);
            }));
            this.doneButton = this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.general.done", new Object[0]), this.width / 2 + 4, this.height - 28, 150, 20, button -> {
                ConfigBase.INSTANCE.configFileINSTANCE.saveToFile();
                Objects.requireNonNull(this.minecraft).setScreen(this.parent);
            }));
            this.list = new ConfigListWidget(this.minecraft, this.width * 2, this.height, 32, 32, 25);
            this.addWidget((GuiEventListener)this.list);
            for (AbstractConfigType<?, ?> info : ConfigBase.INSTANCE.entries) {
                try {
                    if (!info.getCategory().matches(this.category) || !info.getAppearance().showInGui) continue;
                    this.addMenuItem(info);
                }
                catch (Exception e) {
                    String message = "ERROR: Failed to show [\" + info.getNameWCategory() + \"], error: [" + e.getMessage() + "]";
                    if (info.get() != null) {
                        message = message + " with the value [" + String.valueOf(info.get()) + "] with type [" + String.valueOf(info.getType()) + "]";
                    }
                    LOGGER.error(message, (Throwable)e);
                }
            }
            ClassicConfigGUI.CONFIG_CORE_INTERFACE.onScreenChangeListenerList.forEach(listener -> listener.run());
        }

        private void addMenuItem(AbstractConfigType info) {
            Button widget;
            ClassicConfigGUI.initEntry(info, this.translationPrefix);
            MutableComponent name = GuiHelper.Translatable(this.translationPrefix + info.getNameWCategory(), new Object[0]);
            if (ConfigEntry.class.isAssignableFrom(info.getClass())) {
                Button.OnPress btnAction = button -> {
                    ((ConfigEntry)info).uiSetWithoutSaving(((ConfigEntry)info).getDefaultValue());
                    ((EntryInfo)info.guiValue).index = 0;
                    this.reload = true;
                    Objects.requireNonNull(this.minecraft).setScreen((Screen)this);
                };
                int posX = this.width - 10 - 150 - 5 - 40;
                int posZ = 0;
                Button resetButton = GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.general.reset", new Object[0]).withStyle(ChatFormatting.RED), posX, posZ, 40, 20, btnAction);
                if (((EntryInfo)info.guiValue).widget instanceof Map.Entry) {
                    Map.Entry widget2 = (Map.Entry)((EntryInfo)info.guiValue).widget;
                    if (info.getType().isEnum()) {
                        widget2.setValue(value -> GuiHelper.Translatable(this.translationPrefix + "enum." + info.getType().getSimpleName() + "." + info.get().toString(), new Object[0]));
                    }
                    this.list.addButton((AbstractWidget)GuiHelper.MakeBtn((Component)((Function)widget2.getValue()).apply(info.get()), this.width - 150 - 10, 0, 150, 20, (Button.OnPress)widget2.getKey()), (AbstractWidget)resetButton, null, (Component)name);
                    return;
                }
                if (((EntryInfo)info.guiValue).widget != null) {
                    EditBox widget3 = new EditBox(this.font, this.width - 150 - 10 + 2, 0, 146, 20, null);
                    widget3.setMaxLength(150);
                    widget3.insertText(String.valueOf(info.get()));
                    Predicate processor = (Predicate)((BiFunction)((EntryInfo)info.guiValue).widget).apply(widget3, this.doneButton);
                    widget3.setFilter(processor);
                    this.list.addButton((AbstractWidget)widget3, (AbstractWidget)resetButton, null, (Component)name);
                    return;
                }
            }
            if (ConfigCategory.class.isAssignableFrom(info.getClass())) {
                widget = GuiHelper.MakeBtn((Component)name, this.width / 2 - 100, this.height - 28, 200, 20, button -> {
                    ConfigBase.INSTANCE.configFileINSTANCE.saveToFile();
                    Objects.requireNonNull(this.minecraft).setScreen(ClassicConfigGUI.getScreen(this.configBase, this, ((ConfigCategory)info).getDestination()));
                });
                this.list.addButton((AbstractWidget)widget, null, null, null);
                return;
            }
            if (ConfigUIButton.class.isAssignableFrom(info.getClass())) {
                widget = GuiHelper.MakeBtn((Component)name, this.width / 2 - 100, this.height - 28, 200, 20, button -> ((ConfigUIButton)info).runAction());
                this.list.addButton((AbstractWidget)widget, null, null, null);
                return;
            }
            if (ConfigUIComment.class.isAssignableFrom(info.getClass())) {
                this.list.addButton(null, null, null, (Component)name);
                return;
            }
            if (ConfigUiLinkedEntry.class.isAssignableFrom(info.getClass())) {
                this.addMenuItem((AbstractConfigType)((ConfigUiLinkedEntry)info).get());
                return;
            }
            LOGGER.warn("Config [" + info.getNameWCategory() + "] failed to show. Please try something like changing its type.");
        }

        public void render(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
            super.render(matrices, mouseX, mouseY, delta);
            this.list.render(matrices, mouseX, mouseY, delta);
            this.DhDrawCenteredString(matrices, this.font, this.title, this.width / 2, 15, 0xFFFFFF);
            if (this.configBase.modID.equals("distanthorizons")) {
                this.DhDrawString(matrices, this.font, (Component)GuiHelper.TextOrLiteral("2.3.0-b"), 2, this.height - 10, 0xAAAAAA);
                if (SelfUpdater.deleteOldJarOnJvmShutdown) {
                    this.DhDrawString(matrices, this.font, (Component)GuiHelper.Translatable(this.configBase.modID + ".updater.waitingForClose", new Object[0]), 4, this.height - 38, 0xFFFFFF);
                }
            }
            for (AbstractConfigType abstractConfigType : ConfigBase.INSTANCE.entries) {
                AbstractWidget buttonWidget;
                Component text;
                if (!abstractConfigType.getCategory().matches(this.category) || !abstractConfigType.getAppearance().showInGui || !this.list.getHoveredButton(mouseX, mouseY).isPresent() || (text = ButtonEntry.buttonsWithText.get(buttonWidget = this.list.getHoveredButton(mouseX, mouseY).get())) == null) continue;
                AbstractConfigType newInfo = ConfigUiLinkedEntry.class.isAssignableFrom(abstractConfigType.getClass()) ? (AbstractConfigType)((ConfigUiLinkedEntry)abstractConfigType).get() : abstractConfigType;
                MutableComponent name = GuiHelper.Translatable(this.translationPrefix + (String)(abstractConfigType.category.isEmpty() ? "" : abstractConfigType.category + ".") + abstractConfigType.getName(), new Object[0]);
                String key = this.translationPrefix + (String)(newInfo.category.isEmpty() ? "" : newInfo.category + ".") + newInfo.getName() + ".@tooltip";
                if (((EntryInfo)newInfo.guiValue).error != null && text.equals((Object)name)) {
                    this.DhRenderTooltip(matrices, this.font, ((EntryInfo)newInfo.guiValue).error.getValue(), mouseX, mouseY);
                    continue;
                }
                if (!I18n.exists((String)key) || text == null || !text.equals((Object)name)) continue;
                ArrayList<Component> list = new ArrayList<Component>();
                for (String str : I18n.get((String)key, (Object[])new Object[0]).split("\n")) {
                    list.add((Component)GuiHelper.TextOrTranslatable(str));
                }
                this.DhRenderComponentTooltip(matrices, this.font, list, mouseX, mouseY);
            }
        }
    }

    private static class ConfigCoreInterface
    implements IConfigGui {
        public final ArrayList<Runnable> onScreenChangeListenerList = new ArrayList();

        private ConfigCoreInterface() {
        }

        @Override
        public void addOnScreenChangeListener(Runnable newListener) {
            this.onScreenChangeListenerList.add(newListener);
        }

        @Override
        public void removeOnScreenChangeListener(Runnable oldListener) {
            this.onScreenChangeListenerList.remove(oldListener);
        }
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font textRenderer = Minecraft.getInstance().font;
        public final AbstractWidget button;
        private final AbstractWidget resetButton;
        private final AbstractWidget indexButton;
        private final Component text;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
        public static final Map<AbstractWidget, Component> buttonsWithText = new HashMap<AbstractWidget, Component>();

        private ButtonEntry(AbstractWidget button, Component text, AbstractWidget resetButton, AbstractWidget indexButton) {
            buttonsWithText.put(button, text);
            this.button = button;
            this.resetButton = resetButton;
            this.text = text;
            this.indexButton = indexButton;
            if (button != null) {
                this.children.add(button);
            }
            if (resetButton != null) {
                this.children.add(resetButton);
            }
            if (indexButton != null) {
                this.children.add(indexButton);
            }
        }

        public static ButtonEntry create(AbstractWidget button, Component text, AbstractWidget resetButton, AbstractWidget indexButton) {
            return new ButtonEntry(button, text, resetButton, indexButton);
        }

        public void render(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.button != null) {
                GuiHelper.SetY(this.button, y);
                this.button.render(matrices, mouseX, mouseY, tickDelta);
            }
            if (this.resetButton != null) {
                GuiHelper.SetY(this.resetButton, y);
                this.resetButton.render(matrices, mouseX, mouseY, tickDelta);
            }
            if (this.indexButton != null) {
                GuiHelper.SetY(this.indexButton, y);
                this.indexButton.render(matrices, mouseX, mouseY, tickDelta);
            }
            if (!(this.text == null || this.text.getString().contains("spacer") && this.button == null)) {
                matrices.drawString(textRenderer, this.text, 12, y + 5, 0xFFFFFF);
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }
    }

    public static class ConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        Font textRenderer;

        public ConfigListWidget(Minecraft minecraftClient, int canvasWidth, int canvasHeight, int topMargin, int botMargin, int itemSpacing) {
            super(minecraftClient, canvasWidth, canvasHeight - (topMargin + botMargin), topMargin, itemSpacing);
            this.centerListVertically = false;
            this.textRenderer = minecraftClient.font;
        }

        public void addButton(AbstractWidget button, AbstractWidget resetButton, AbstractWidget indexButton, Component text) {
            this.addEntry((AbstractSelectionList.Entry)ButtonEntry.create(button, text, resetButton, indexButton));
        }

        public int getRowWidth() {
            return 10000;
        }

        public Optional<AbstractWidget> getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.children()) {
                if (buttonEntry.button == null || !buttonEntry.button.isMouseOver(mouseX, mouseY)) continue;
                return Optional.of(buttonEntry.button);
            }
            return Optional.empty();
        }
    }

    private static class ConfigScreenConfigs {
        public static final int SpaceFromRightScreen = 10;
        public static final int ButtonWidthSpacing = 5;
        public static final int ResetButtonWidth = 40;
        public static final int ResetButtonHeight = 20;

        private ConfigScreenConfigs() {
        }
    }
}

